/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import java.awt.Label;

public class HexInputRO
extends Label
implements JDMInput {
    protected boolean hasErrorValue;
    protected boolean ignoreValue;

    public HexInputRO() {
        this.setForeground(JmaColors.textText);
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public HexInputRO(String string) {
        super(string);
        this.setForeground(JmaColors.textText);
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public void setText(String string) {
        super.setText(string);
        this.setForeground(JmaColors.textText);
        this.hasErrorValue = false;
        this.ignoreValue = false;
        this.invalidate();
    }

    public Object getValue() {
        return new OctetString(this.getText());
    }

    public String toString() {
        return new String(this.getText());
    }

    public void setValue(String string) {
        this.setText(string);
        this.hasErrorValue = false;
        this.ignoreValue = false;
    }

    public void setValue(Object object) {
        this.hasErrorValue = false;
        this.ignoreValue = false;
        if (object instanceof String) {
            String string = (String)object;
            OctetString octetString = new OctetString(string);
            this.setText(octetString.toString());
            return;
        }
        if (object instanceof OctetString) {
            this.setText(((OctetString)object).toString());
            return;
        }
        if (object instanceof SpecialValue) {
            SpecialValue specialValue = (SpecialValue)object;
            this.setText(specialValue.toString());
            this.hasErrorValue = true;
            if (object instanceof NotSupported) {
                this.ignoreValue = true;
            }
        }
    }

    public boolean isValidValue() {
        return !this.hasErrorValue;
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }
}

